/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.profiling.ActiveProfiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.example.ExampleGuiPortalRendering;
import qouteall.imm_ptl.core.chunk_loading.ChunkVisibility;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTickets;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.ducks.IEChunkTicketManager;
import qouteall.imm_ptl.core.ducks.IEServerChunkManager;
import qouteall.imm_ptl.core.ducks.IEServerWorld;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.mixin.common.chunk_sync.IEChunkMap_Accessor;
import qouteall.imm_ptl.core.mixin.common.mc_util.IELevelEntityGetterAdapter;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.Mesh2D;
import qouteall.q_misc_util.my_util.MyTaskList;

public class PortalDebugCommands {
    private static final Logger LOGGER = LogUtils.getLogger();

    static void registerDebugCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"gui_portal").then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> {
            ExampleGuiPortalRendering.onCommandExecuted(((CommandSourceStack)context.getSource()).m_81375_(), DimensionArgument.m_88808_((CommandContext)context, (String)"dim"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"));
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"isometric_enable").then(Commands.m_82129_((String)"viewLength", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            float viewLength = FloatArgumentType.getFloat((CommandContext)context, (String)"viewLength");
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.render.TransformationManager.RemoteCallables.enableIsometricView", Float.valueOf(viewLength));
            return 0;
        })));
        builder.then(Commands.m_82127_((String)"isometric_disable").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.render.TransformationManager.RemoteCallables.disableIsometricView", new Object[0]);
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"align").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Vec3 pos = player.m_20182_();
            Vec3 newPos = new Vec3((double)Math.round(pos.f_82479_ * 2.0) / 2.0, (double)Math.round(pos.f_82480_ * 2.0) / 2.0, (double)Math.round(pos.f_82481_ * 2.0) / 2.0);
            player.f_8906_.m_9774_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, 45.0f, 30.0f);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"profile").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set_lag_logging_threshold").requires(serverCommandSource -> serverCommandSource.m_6761_(4))).then(Commands.m_82129_((String)"ms", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int ms = IntegerArgumentType.getInteger((CommandContext)context, (String)"ms");
            ActiveProfiler.f_18368_ = Duration.ofMillis(ms).toNanos();
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"gc").requires(serverCommandSource -> serverCommandSource.m_6761_(4))).executes(context -> {
            System.gc();
            long l = Runtime.getRuntime().maxMemory();
            long m = Runtime.getRuntime().totalMemory();
            long n = Runtime.getRuntime().freeMemory();
            long o = m - n;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Memory: % 2d%% %03d/%03dMB", o * 100L / l, PortalDebugCommands.toMiB(o), PortalDebugCommands.toMiB(l))), false);
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"create_command_stick").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).then(Commands.m_82129_((String)"command", (ArgumentType)StringArgumentType.string()).executes(context -> {
            PortalCommand.createCommandStickCommandSignal.emit(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"command"));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"accelerate").requires(PortalCommand::canUsePortalCommand)).then(Commands.m_82129_((String)"v", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            double v = DoubleArgumentType.getDouble((CommandContext)context, (String)"v");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            Vec3 vec = player.m_20252_(1.0f).m_82490_(v / 20.0);
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).m_81375_(), "qouteall.imm_ptl.core.commands.PortalCommand.RemoteCallables.clientAccelerate", vec);
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"accelerate_along").requires(PortalCommand::canUsePortalCommand)).then(Commands.m_82129_((String)"vec", (ArgumentType)Vec3Argument.m_120847_((boolean)false)).executes(context -> {
            Vec3 vec = Vec3Argument.m_120844_((CommandContext)context, (String)"vec");
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).m_81375_(), "qouteall.imm_ptl.core.commands.PortalCommand.RemoteCallables.clientAccelerate", vec.m_82490_(0.05));
            return 0;
        })));
        builder.then(Commands.m_82127_((String)"test").executes(context -> 0));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"erase_chunk").requires(serverCommandSource -> serverCommandSource.m_6761_(3))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"rChunks", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ChunkPos center = new ChunkPos(BlockPos.m_274446_((Position)player.m_20182_()));
            PortalDebugCommands.invokeEraseChunk(player.m_9236_(), center, IntegerArgumentType.getInteger((CommandContext)context, (String)"rChunks"), McHelper.getMinY((LevelAccessor)player.m_9236_()), McHelper.getMaxYExclusive((LevelAccessor)player.m_9236_()));
            return 0;
        })).then(Commands.m_82129_((String)"downY", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"upY", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ChunkPos center = new ChunkPos(BlockPos.m_274446_((Position)player.m_20182_()));
            PortalDebugCommands.invokeEraseChunk(player.m_9236_(), center, IntegerArgumentType.getInteger((CommandContext)context, (String)"rChunks"), IntegerArgumentType.getInteger((CommandContext)context, (String)"downY"), IntegerArgumentType.getInteger((CommandContext)context, (String)"upY"));
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"report_chunk_loaders").requires(serverCommandSource -> serverCommandSource.m_6761_(3))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ChunkVisibility.foreachBaseChunkLoaders(player, loader -> McHelper.serverLog(player, loader.toString()));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"report_server_entities_nearby").requires(serverCommandSource -> serverCommandSource.m_6761_(3))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            List entities = player.m_9236_().m_6443_(Entity.class, new AABB(player.m_20182_(), player.m_20182_()).m_82400_(32.0), e -> true);
            McHelper.serverLog(player, entities.stream().map(Entity::toString).collect(Collectors.joining("\n")));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"is_chunk_loaded").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int chunkX = IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkX");
            int chunkZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkZ");
            ServerLevel world = DimensionArgument.m_88808_((CommandContext)context, (String)"dim");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            PortalDebugCommands.doReportChunkStatus(chunkX, chunkZ, world, player);
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"report_chunk_at").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            ServerLevel world = DimensionArgument.m_88808_((CommandContext)context, (String)"dim");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"pos");
            ChunkPos chunkPos = new ChunkPos(pos);
            PortalDebugCommands.doReportChunkStatus(chunkPos.f_45578_, chunkPos.f_45579_, world, player);
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"report_player_status").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CHelper.printChat(String.format("On Server %s %s removal:%s added:%s age:%s", player.m_9236_().m_46472_().m_135782_(), player.m_20183_(), player.m_146911_(), player.m_9236_().m_6815_(player.m_19879_()) != null, player.f_19797_));
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportClientPlayerStatus", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list_portals").requires(serverCommandSource -> serverCommandSource.m_6761_(3))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            StringBuilder result = new StringBuilder();
            result.append("Server Portals\n");
            for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
                result.append(world.m_46472_().m_135782_().toString() + "\n");
                for (Entity entity : world.m_8583_()) {
                    for (Entity e : world.m_8583_()) {
                        if (!(e instanceof Portal)) continue;
                        result.append(e.toString());
                        result.append("\n");
                    }
                }
            }
            McHelper.serverLog(player, result.toString());
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.doListPortals", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"report_resource_consumption").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).executes(context -> {
            StringBuilder str = new StringBuilder();
            str.append("Server Tracked Chunks:\n");
            MiscHelper.getServer().m_129785_().forEach(world -> str.append(PortalDebugCommands.getServerWorldResourceConsumption(world)));
            McHelper.serverLog(((CommandSourceStack)context.getSource()).m_81375_(), str.toString());
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).m_81375_(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportResourceConsumption", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"report_chunk_ticket_stat").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            Iterable<ChunkHolder> chunkHolders = ((IEChunkMap_Accessor)world.m_7726_().f_8325_).ip_getChunks();
            Object2IntOpenHashMap stat = new Object2IntOpenHashMap();
            for (ChunkHolder chunkHolder : chunkHolders) {
                long chunkPos = chunkHolder.m_140092_().m_45588_();
                SortedArraySet<Ticket<?>> chunkTickets = ((IEChunkTicketManager)ImmPtlChunkTickets.getDistanceManager(world)).portal_getTicketSet(chunkPos);
                for (Ticket ticket : chunkTickets) {
                    stat.addTo((Object)ticket.m_9428_(), 1);
                }
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)""), false);
            for (Object2IntMap.Entry entry : stat.object2IntEntrySet()) {
                TicketType ticketType = (TicketType)entry.getKey();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(ticketType.toString() + " " + entry.getIntValue())), false);
            }
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"report_per_player_chunk_loading").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).executes(context -> {
            List players = MiscHelper.getServer().m_6846_().m_11314_();
            for (ServerPlayer player : players) {
                NewChunkTrackingGraph.PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
                String text = "%s %d".formatted(player.m_7755_().getString(), playerInfo.loadedChunks);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)text), true);
            }
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"save_all_chunks").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).executes(context -> {
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            server.m_129885_(true, true, false);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"simplify_portal_mesh").requires(serverCommandSource -> serverCommandSource.m_6761_(2))).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            GeometryPortalShape shape = portal.specialShape;
            if (shape != null) {
                Mesh2D mesh = shape.toMesh();
                mesh.simplifySteps(1);
                portal.specialShape = GeometryPortalShape.fromMesh(mesh);
                portal.reloadPortal();
            }
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"check_biome_registry").requires(serverCommandSource -> serverCommandSource.m_6761_(3))).executes(context -> {
            RegistryAccess.Frozen registryAccess = MiscHelper.getServer().m_206579_();
            Registry biomes = registryAccess.m_175515_(Registries.f_256952_);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Map.Entry entry : biomes.m_6579_()) {
                String strId = ((ResourceKey)entry.getKey()).m_135782_().toString();
                int intId = biomes.m_7447_((Object)((Biome)entry.getValue()));
                map.put(strId, intId);
            }
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).m_81375_(), "qouteall.imm_ptl.core.ClientWorldLoader.RemoteCallables.checkBiomeRegistry", map);
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"nofog_enable").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).m_81375_(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.setNoFog", true);
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"nofog_disable").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).m_81375_(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.setNoFog", false);
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"report_air").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockState blockState = player.m_9236_().m_8055_(player.m_20183_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> blockState.m_60734_().m_49954_(), false);
            return 0;
        }));
        builder.then(Commands.m_82127_((String)"test_invalid_rpc").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).m_81375_(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.testInvalidRPC", new Object[0]);
            return 0;
        }));
    }

    private static void doReportChunkStatus(int chunkX, int chunkZ, ServerLevel world, ServerPlayer player) {
        LevelChunk chunk = McHelper.getServerChunkIfPresent(world, chunkX, chunkZ);
        boolean loaded = chunk != null && !(chunk instanceof EmptyLevelChunk);
        long longChunkPos = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        if (loaded) {
            boolean shouldTickEntities = ImmPtlChunkTickets.getDistanceManager(world).m_183913_(longChunkPos);
            if (shouldTickEntities) {
                McHelper.serverLog(player, "Server chunk loaded and entity tickable");
            } else {
                McHelper.serverLog(player, "Server chunk loaded but entity not tickable");
            }
        } else {
            McHelper.serverLog(player, "Server chunk not loaded");
        }
        ChunkHolder chunkHolder = McHelper.getIEStorage((ResourceKey<Level>)world.m_46472_()).ip_getChunkHolder(longChunkPos);
        if (chunkHolder == null) {
            McHelper.serverLog(player, "no chunk holder");
        } else {
            McHelper.serverLog(player, String.format("chunk holder level:%s %s", chunkHolder.m_140093_(), chunk == null ? "" : chunk.m_287138_()));
            DistanceManager distanceManager = ((IEServerChunkManager)world.m_7726_()).ip_getDistanceManager();
            SortedArraySet<Ticket<?>> tickets = ((IEChunkTicketManager)distanceManager).portal_getTicketSet(longChunkPos);
            for (Ticket ticket : tickets) {
                McHelper.serverLog(player, ticket.toString());
            }
        }
        McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportClientChunkLoadStatus", world.m_46472_(), chunkX, chunkZ);
    }

    public static String getServerWorldResourceConsumption(ServerLevel world) {
        StringBuilder subStr = new StringBuilder();
        ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
        LevelEntityGetter<Entity> entityLookup = ((IEWorld)world).portal_getEntityLookup();
        subStr.append(String.format("%s:\nImmPtl Tracked Chunks: %s\nImmPtl Loading Ticket:%s\nChunks: %s\nEntities:%s Entity Sections:%s\n", world.m_46472_().m_135782_(), NewChunkTrackingGraph.getLoadedChunkNum((ResourceKey<Level>)world.m_46472_()), dimTicketManager.getLoadedChunkNum(), world.m_7726_().f_8325_.m_140394_(), ((IELevelEntityGetterAdapter)entityLookup).getIndex().m_156821_(), ((IELevelEntityGetterAdapter)entityLookup).getCache().m_156887_()));
        PersistentEntitySectionManager<Entity> entityManager = ((IEServerWorld)world).ip_getEntityManager();
        entityManager.m_157561_();
        subStr.append(String.format("Entity Manager: %s\n", entityManager.m_157572_()));
        subStr.append("\n");
        String result = subStr.toString();
        return result;
    }

    public static long toMiB(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static void invokeEraseChunk(Level world, ChunkPos center, int r, int downY, int upY) {
        ArrayList<ChunkPos> poses = new ArrayList<ChunkPos>();
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                poses.add(new ChunkPos(x + center.f_45578_, z + center.f_45579_));
            }
        }
        poses.sort(Comparator.comparingDouble(c -> Vec3.m_82528_((Vec3i)center.m_45615_()).m_82554_(Vec3.m_82528_((Vec3i)c.m_45615_()))));
        IPGlobal.serverTaskList.addTask(MyTaskList.chainTasks(poses.stream().map(chunkPos -> () -> {
            PortalDebugCommands.eraseChunk(chunkPos, world, downY, upY);
            return true;
        }).iterator()));
    }

    public static void eraseChunk(ChunkPos chunkPos, Level world, int yStart, int yEnd) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = yStart; y < yEnd; ++y) {
                    world.m_46597_(new BlockPos(chunkPos.m_45604_() + x, y, chunkPos.m_45605_() + z), Blocks.f_50016_.m_49966_());
                }
            }
        }
    }
}

